

	/*For Date Picker*/
	$( ".date-picker").datepicker({
		inline: true,
		nextText: '&rarr;',
		prevText: '&larr;',
		showOtherMonths: true,
		changeMonth: true,
        changeYear: true,
		dateFormat: 'dd/mm/yy',
		dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
     	showAnim: "slide"
	});
	
	/*For DOB Date Picker*/
	$( ".dob-date-picker").datepicker({
		inline: true,
		nextText: '&rarr;',
		prevText: '&larr;',
		showOtherMonths: true,
		changeMonth: true,
        changeYear: true,
        yearRange: '1950:2025',
		dateFormat: 'dd/mm/yy',
		dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
		maxDate: new Date(),
     	showAnim: "slide"
	});

	/*For Single Time Picker*/
	$('.timepicker').timepicker({
		showLeadingZero: false,
	});

	/*For From-To Time Picker*/
	$('.from-timepicker').timepicker({
		showLeadingZero: false,
		onSelect: tpStartSelect
	});
	
	$('.to-timepicker').timepicker({
		showLeadingZero: false,
		onSelect: tpEndSelect
	});
							
	// when start time change, update minimum for end time picker
	function tpStartSelect( time, endTimePickerInst ) {
		$('.to-timepicker').timepicker('option', {
			minTime: {
				hour: endTimePickerInst.hours,
				minute: endTimePickerInst.minutes
			}
		});
	}
							
	// when end time change, update maximum for start time picker
	function tpEndSelect( time, startTimePickerInst ) {
		$('.from-timepicker').timepicker('option', {
			maxTime: {
				hour: startTimePickerInst.hours,
				minute: startTimePickerInst.minutes
			}
		});
	}
	
	
	// Date Picker For When dynamically created input date 
	$(document).on('focus',".date-picker", function(){ //bind to all instances of class "date". 
	    $( this).datepicker({
			inline: true,
			nextText: '&rarr;',
			prevText: '&larr;',
			showOtherMonths: true,
			changeMonth: true,
	        changeYear: true,
			dateFormat: 'dd/mm/yy',
			dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
	     	showAnim: "slide"
		});
	});
	
	$(document).on('focus',".dob-date-picker", function(){ //bind to all instances of class "date". 
	    $( this).datepicker({
	    	inline: true,
			nextText: '&rarr;',
			prevText: '&larr;',
			showOtherMonths: true,
			changeMonth: true,
	        changeYear: true,
	        yearRange: '1950:2025',
			dateFormat: 'dd/mm/yy',
			dayNamesMin: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
			maxDate: new Date(),
	     	showAnim: "slide"
		});
	});
	
	// Time Picker For When dynamically created input date 
	$(document).on('focus',".timepicker", function(){ //bind to all instances of class "date". 
		$(this).timepicker({
			showLeadingZero: false
		});
	});
	
							             
