/* 
    Popup JavaScript from Dynamic Web Coding at dyn-web.com
    Copyright 2001-2013 by Sharon Paine
    For demos, documentation and updates, visit http://www.dyn-web.com/code/popup/

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

var DYN_WEB = DYN_WEB || {};

/*
    dw_event.js - version date May 2013 (added .domReady)
    .domReady uses whenReady fn from JavaScript the Definitive Guide
    6th edition by David Flanagan, example 17.01
*/
DYN_WEB.Event=(function(Ev){Ev.add=document.addEventListener?function(obj,etype,fp,cap){cap=cap||false;obj.addEventListener(etype,fp,cap);}:function(obj,etype,fp){obj.attachEvent('on'+etype,fp);};Ev.remove=document.removeEventListener?function(obj,etype,fp,cap){cap=cap||false;obj.removeEventListener(etype,fp,cap);}:function(obj,etype,fp){obj.detachEvent('on'+etype,fp);};Ev.DOMit=function(e){e=e?e:window.event;if(!e.target){e.target=e.srcElement;}if(!e.preventDefault){e.preventDefault=function(){e.returnValue=false;return false;};}if(!e.stopPropagation){e.stopPropagation=function(){e.cancelBubble=true;};}return e;};Ev.getTarget=function(e){e=Ev.DOMit(e);var tgt=e.target;if(tgt.nodeType!==1){tgt=tgt.parentNode;}return tgt;};Ev.domReady=(function(){var funcs=[];var ready=false;function handler(e){if(ready){return;}if(e.type==="readystatechange"&&document.readyState!=="complete"){return;}for(var i=0,len=funcs.length;i<len;i++){funcs[i].call(document);}ready=true;funcs=[];}if(document.addEventListener){document.addEventListener("DOMContentLoaded",handler,false);document.addEventListener("readystatechange",handler,false);window.addEventListener("load",handler,false);}else if(document.attachEvent){document.attachEvent("onreadystatechange",handler);window.attachEvent("onload",handler);}return function whenReady(f){if(ready){f.call(document);}else{funcs.push(f);}};})();return Ev;})(DYN_WEB.Event||{});

DYN_WEB.Viewport={_docEl:null,getDocEl:function(){var mode='',doc=document;if(!this._docEl){mode=doc.compatMode;this._docEl=(mode==='CSS1Compat')?doc.documentElement:doc.body;}return this._docEl;},getWidth:function(){var width=this.getDocEl().clientWidth;if(window.innerWidth&&width>window.innerWidth){width=window.innerWidth;}return width;},getHeight:function(){var height=this.getDocEl().clientHeight;if(window.innerHeight&&height>window.innerHeight){height=window.innerHeight;}return height;},getScrollX:function(){var sx=(typeof window.pageXOffset==='number')?window.pageXOffset:this.getDocEl().scrollLeft;return sx;},getScrollY:function(){var sy=(typeof window.pageYOffset==='number')?window.pageYOffset:this.getDocEl().scrollTop;return sy;},getAll:function(){return{width:this.getWidth(),height:this.getHeight(),scrollX:this.getScrollX(),scrollY:this.getScrollY()};}};

DYN_WEB.Util=(function(Ut){Ut.$=function(id){return document.getElementById(id);};Ut.getCurrentStyle=function(el,prop){var val='',style,runtimeStyle;if(window.getComputedStyle){val=window.getComputedStyle(el,null)[prop];}else if(el.currentStyle){val=el.currentStyle[prop];if(!/^\d+(px)?$/i.test(val)&&/^\d/.test(val)){style=el.style.left;runtimeStyle=el.runtimeStyle.left;el.runtimeStyle.left=el.currentStyle.left;el.style.left=val||0;val=el.style.pixelLeft+"px";el.style.left=style;el.runtimeStyle.left=runtimeStyle;}}return val;};Ut.contained=function(oNode,oCont){if(!oNode){return false;}while((oNode=oNode.parentNode)){if(oNode===oCont){return true;}}return false;};Ut.hasClass=function(el,cl){var re=new RegExp('\\b'+cl+'\\b','i');if(re.test(el.className)){return true;}return false;};Ut.getElementsByClassName=function(cl,tag,el){el=(el&&el.getElementsByTagName)?el:document;if(tag&&el.querySelectorAll){return el.querySelectorAll(tag+'.'+cl);}else if(el.getElementsByClassName){return el.getElementsByClassName(cl);}else{tag=tag||'*';var result=[],re=new RegExp('\\b'+cl+'\\b','i'),list=el.getElementsByTagName(tag);for(var i=0,len=list.length;i<len;i++){if(re.test(list[i].className)){result.push(list[i]);}}return result;}};Ut.getPageOffsets=function(el){var VP=DYN_WEB.Viewport,left=0,top=0,props;if(el.getBoundingClientRect){props=el.getBoundingClientRect();left=props.left+VP.getScrollX();top=props.top+VP.getScrollY();}else{do{left+=el.offsetLeft;top+=el.offsetTop;}while((el=el.offsetParent));}return{x:left,y:top};};return Ut;})(DYN_WEB.Util||{});

DYN_WEB.Draggable=(function(){var Ut=DYN_WEB.Util,Ev=DYN_WEB.Event,VP=DYN_WEB.Viewport;function D(id,handleId,opts){var el=Ut.$(id);if(!el){throw new Error('new DYN_WEB.Draggable: No element with the specified id found.');}this.id=id;D.col[id]=this;var handle;var x=parseInt(Ut.getCurrentStyle(el,'left'),10);var y=parseInt(Ut.getCurrentStyle(el,'top'),10);x=isNaN(x)?0:x;y=isNaN(y)?0:y;if(opts){this.minX=(typeof opts.minX==='number')?opts.minX:undefined;this.maxX=(typeof opts.maxX==='number')?opts.maxX:undefined;this.minY=(typeof opts.minY==='number')?opts.minY:undefined;this.maxY=(typeof opts.maxY==='number')?opts.maxY:undefined;this.on_drag_start=(typeof opts.on_drag_start==='function')?opts.on_drag_start:this.on_drag_start;this.on_drag=(typeof opts.on_drag==='function')?opts.on_drag:this.on_drag;this.on_drag_end=(typeof opts.on_drag_end==='function')?opts.on_drag_end:this.on_drag_end;}D.shiftTo(el,x,y);if(handleId){handle=Ut.$(handleId);if(!handle){throw new Error('new DYN_WEB.Draggable: No element with the specified handleId found.');}else if(!Ut.contained(handle,el)){throw new Error('new DYN_WEB.Draggable: No element with id '+handleId+' found inside '+id+'.');}}else{handle=el;}Ev.add(handle,'mousedown',D.start);}D.prototype={on_drag_start:function(){},on_drag:function(){},on_drag_end:function(){}};D.col={};D.current='';D.zOrder=1000;D.start=function(e){var el,_this,downX,downY,x,y,ctr=0,maxLoops=10;e=Ev.DOMit(e);var tgt=Ev.getTarget(e);do{if(tgt.id&&(_this=D.col[tgt.id])){el=Ut.$(tgt.id);D.current=tgt.id;break;}ctr++;}while(ctr<maxLoops&&(tgt=tgt.parentNode));if(!el){throw new Error('Unable to find Draggable element onmousedown.');}el.style.zIndex=D.zOrder++;downX=e.clientX+VP.getScrollX();downY=e.clientY+VP.getScrollY();x=parseInt(el.style.left,10)||0;y=parseInt(el.style.top,10)||0;_this.dx=downX-x;_this.dy=downY-y;_this.on_drag_start(x,y);Ev.add(document,'mousemove',D.drag);Ev.add(document,'mouseup',D.end);e.preventDefault();e.stopPropagation();};D.drag=function(e){e=Ev.DOMit(e);var _this=D.col[D.current],el=Ut.$(D.current),nx=e.clientX+VP.getScrollX()-_this.dx,ny=e.clientY+VP.getScrollY()-_this.dy;nx=(typeof _this.minX!=='undefined')?Math.max(_this.minX,nx):nx;nx=(typeof _this.maxX!=='undefined')?Math.min(_this.maxX,nx):nx;ny=(typeof _this.minY!=='undefined')?Math.max(_this.minY,ny):ny;ny=(typeof _this.maxY!=='undefined')?Math.min(_this.maxY,ny):ny;D.shiftTo(el,nx,ny);_this.on_drag(nx,ny);e.preventDefault();};D.end=function(){var _this=D.col[D.current],el=Ut.$(D.current),x,y;Ev.remove(document,'mousemove',D.drag);Ev.remove(document,'mouseup',D.end);if(el){x=parseInt(el.style.left,10);y=parseInt(el.style.top,10);_this.on_drag_end(x,y);}D.current='';};D.setup=function(){var cur;for(var i=0,len=arguments.length;i<len;i++){cur=arguments[i];if(typeof cur==='string'){new D(cur);}else{new D(cur.id,cur.handleId,cur);}}};D.shiftTo=function(el,x,y){el.style.left=parseInt(x,10)+'px';el.style.top=parseInt(y,10)+'px';};return D;})();

DYN_WEB.Popup=(function(){var Ut=DYN_WEB.Util,Ev=DYN_WEB.Event,VP=DYN_WEB.Viewport,D=DYN_WEB.Draggable;function Popup(id,handleId,opts){this.id=id;var el=Ut.$(id);if(!el){throw new Error('new DYN_WEB.Popup: No element with the specified id found.');}Popup.col[this.id]=this;Popup.ids[Popup.ids.length]=this.id;if(opts){this.center=(typeof opts.center==='boolean')?opts.center:this.center;this.draggable=(typeof opts.draggable==='boolean')?opts.draggable:this.draggable;this.left=(typeof opts.left==='boolean')?opts.left:this.left;this.right=(typeof opts.right==='boolean')?opts.right:this.right;this.offX=(typeof opts.offX==='number')?opts.offX:this.offX;this.offY=(typeof opts.offY==='number')?opts.offY:this.offY;this.minX=(typeof opts.minX==='number')?opts.minX:this.minX;this.minY=(typeof opts.minY==='number')?opts.minY:this.minY;}if(this.center){this.posCenter=true;if(!Popup.resizeSet){Ev.add(window,'resize',function(){Popup.doOnResize();});Popup.resizeSet=true;}this.positionCenter();}if(this.draggable){this.Drag=new D(id,handleId,{minX:this.minX,minY:this.minY});this.Drag.on_drag_start=function(){this.isDragged=true;};}Popup.handleCloseLink(id);this.on_init();}Popup.col={};Popup.ids=[];Popup.setProps=function(){var settings=Popup.defaultProps||{},prop;var list=[['center','boolean',false],['left','boolean',false],['right','boolean',false],['minX','number',0],['minY','number',0],['offX','number',0],['offY','number',0],['draggable','boolean',true]];for(var i=0,len=list.length;i<len;i++){prop=list[i][0];Popup.prototype[prop]=(typeof settings[prop]===list[i][1])?settings[prop]:list[i][2];}};Popup.setup=function(){var cur;Popup.setProps();for(var i=0,len=arguments.length;i<len;i++){cur=arguments[i];if(typeof cur==='string'){new Popup(cur);}else{new Popup(cur.id,cur.handleId,cur);}}Ev.add(document,'click',Popup.check4ShowLink,true);};Popup.getInstance=function(id){return Popup.col[id];};Popup.doOnResize=function(){var p;for(var i=Popup.ids.length;i--;){p=Popup.col[Popup.ids[i]];if(p.posCenter&&!p.Drag.isDragged){p.positionCenter();}}};Popup.handleCloseLink=function(id){var list=Ut.getElementsByClassName('closeBox','',Ut.$(id));var box=list[0];if(box){Ev.add(box,'click',function(e){e=Ev.DOMit(e);var el=Ut.$(id);el.style.visibility='hidden';e.preventDefault();});Ev.add(box,'mousedown',function(e){e=Ev.DOMit(e);e.stopPropagation();});}};Popup.check4ShowLink=function(e){var tgt=Ev.getTarget(e);var ctr=0,maxCnt=4;var id,el,_this;if(!tgt){return;}do{if(Ut.hasClass(tgt,'showPopup')){id=(tgt.dataset&&tgt.dataset.id)?tgt.dataset.id:tgt.getAttribute('data-id');if(!id){id='popup';}el=Ut.$(id);if(!el){throw new Error('.check4ShowLink fn: no element matching specified showPopup id found.');}_this=Popup.col[id];if(!_this){throw new Error('.check4ShowLink fn: no Popup instance matching specified showPopup id found.');}Popup.check4Content(tgt,el);if(_this.posCenter){_this.positionCenter();}else if(_this.right||_this.left){_this.posRelLink(tgt,el);}el.style.zIndex=D.zOrder++;_this.on_show();el.style.visibility='visible';e.preventDefault();break;}ctr++;}while(ctr<maxCnt&&(tgt=tgt.parentNode));};Popup.check4Content=function(tgt,el){var lookup=(tgt.dataset&&tgt.dataset.lookup)?tgt.dataset.lookup:tgt.getAttribute('data-lookup');var msg,list;if(lookup){list=Ut.getElementsByClassName('popup_content','div',el);msg=Popup.vars[lookup];if(msg){list[0].innerHTML=msg;}}};Popup.prototype={on_init:function(){},on_show:function(){},shiftTo:function(x,y){var el=Ut.$(this.id);el.style.left=parseInt(x,10)+'px';el.style.top=parseInt(y,10)+'px';},show:function(){var el=Ut.$(this.id);el.style.visibility='visible';},positionCenter:function(){var el=Ut.$(this.id);var vp=VP.getAll();var x=Math.round((vp.width-el.offsetWidth)/2)+vp.scrollX;var y=Math.round((vp.height-el.offsetHeight)/2)+vp.scrollY;this.shiftTo(x,y);},posRelLink:function(tgt,el){var x,y;var pos=Ut.getPageOffsets(tgt);if(this.right){x=Math.round(pos.x)+tgt.offsetWidth+this.offX;}else{x=Math.round(pos.x)-el.offsetWidth-this.offX;}y=Math.round(pos.y)+this.offY;this.shiftTo(x,y);}};return Popup;})();